/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWRuleSetUsageDialog;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWWorkflowRuleTableModel;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWRulePanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWRuleSetUsageDialog m_ruleSetUsageDialog = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_ruleTable = null;
    private VWWorkflowRuleTableModel m_ruleTableModel = null;

    public VWRulePanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
        this.reinitialize();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_ruleTable.getRowCount() - 1) {
                    nRow = this.m_ruleTable.getRowCount() - 1;
                }
                if (nRow == this.m_ruleTable.getSelectedRow()) {
                    this.m_ruleTable.clearSelection();
                }
                this.m_ruleTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != -1 || this.m_ruleTable.getSelectedRow() != event.getLastRow()) break;
                this.updateToolbarButtonStates();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateToolbarButtonStates();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int nRowIndex = this.m_ruleTable.getSelectedRow();
            if (nRowIndex == -1) {
                return;
            }
            switch (event.getID()) {
                case 0x10000000: {
                    this.m_ruleTableModel.deleteItem(nRowIndex);
                    if (this.m_ruleTable.getRowCount() <= 0) break;
                    if (nRowIndex == 0) {
                        this.m_ruleTable.setRowSelectionInterval(0, 0);
                        break;
                    }
                    this.m_ruleTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
                    break;
                }
                case 4096: {
                    this.onRuleSetUsage();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        if (this.m_ruleTableModel != null) {
            this.m_ruleTableModel.reinitialize();
        }
        this.m_ruleTable.clearSelection();
        this.m_ruleTable.setRowSelectionInterval(0, 0);
    }

    protected void stopEditing() {
        if (this.m_ruleTable != null) {
            this.m_ruleTable.stopEditing();
        }
    }

    protected void releaseReferences() {
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_ruleTable != null) {
            this.m_ruleTable.getSelectionModel().removeListSelectionListener(this);
            this.m_ruleTable = null;
        }
        if (this.m_ruleTableModel != null) {
            this.m_ruleTableModel.removeTableModelListener(this);
            this.m_ruleTableModel = null;
        }
        if (this.m_ruleSetUsageDialog != null) {
            this.m_ruleSetUsageDialog.removeReferences();
            this.m_ruleSetUsageDialog = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            TableColumn tcElement;
            this.setLayout(new BorderLayout());
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.s_ruleSets, 0x10001000);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, "Center");
            this.m_ruleTableModel = new VWWorkflowRuleTableModel(this.m_authPropertyData, this);
            this.m_ruleTableModel.addTableModelListener(this);
            this.m_ruleTable = new VWTable(this.m_ruleTableModel);
            this.m_ruleTable.setName("m_ruleTable_VWRulePanel");
            this.m_ruleTable.setRowSelectionAllowed(true);
            this.m_ruleTable.getSelectionModel().addListSelectionListener(this);
            this.m_ruleTable.getSelectionModel().setSelectionMode(0);
            this.m_ruleTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_ruleTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_ruleTable.getColumnModel().getColumn(this.m_ruleTableModel.getActualColumnIndex(0))) != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
            }
            if (this.m_authPropertyData.getAllowAsynchronousRules() && (tcElement = this.m_ruleTable.getColumnModel().getColumn(this.m_ruleTableModel.getActualColumnIndex(2))) != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
                tcElement.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("asynchronous.gif"), VWResource.s_asynchronous));
                tcElement.setIdentifier(tcElement.getHeaderRenderer());
            }
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_ruleTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void onRuleSetUsage() {
        try {
            int nRowIndex = this.m_ruleTable.getSelectedRow();
            VWRuleSetDefinition ruleSetDef = (VWRuleSetDefinition)this.m_ruleTableModel.getValueAt(nRowIndex, this.m_ruleTableModel.getActualColumnIndex(1));
            if (this.m_authPropertyData != null && ruleSetDef != null) {
                if (this.m_ruleSetUsageDialog == null) {
                    this.m_ruleSetUsageDialog = new VWRuleSetUsageDialog(this.m_authPropertyData);
                }
                this.m_ruleSetUsageDialog.reinitialize(ruleSetDef);
                if (this.m_ruleSetUsageDialog.hasMaps()) {
                    this.m_ruleSetUsageDialog.setVisible(true);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_noAvailableWritableMaps, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateToolbarButtonStates() {
        int nRowCount;
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        int nRowIndex = this.m_ruleTable.getSelectedRow();
        if (this.m_ruleTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_ruleTableModel.getRowCount()) - 1) {
            if (this.m_ruleTableModel.canDeleteRow(nRowIndex)) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, Integer.MAX_VALUE));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 4096));
            }
        }
    }
}

